varying vec2 		texcoord;
				
uniform vec2		fresnel0,
					spec0;
uniform float 		scatterlevel;
uniform float 		scatterRed;
uniform float 		backScatter;
uniform float		wFar;

uniform float 		reflMul;
	
varying vec3		vertColor;
uniform sampler2D 	dif0;
//uniform vec4		dcolor0;
uniform vec2		dscale0;
uniform vec2		dofs0;

uniform float		matID;
uniform float		metal0;

#ifdef ALPHATEST

	
	/*uniform vec2		dscale0,
						dofs0;*/
	//uniform vec4		dcolor0;
	//uniform sampler2D 	dif0;
	//uniform sampler2D 	noisemap;
	uniform float 		alphalevel;
	varying float		alphaFade;
	
#endif

#ifdef PSYSTEM

	varying float 	life;
	varying float	cosa,
			sina;
	uniform vec4 		particleFade;
		
#else

	#ifdef BSET

		varying vec4 pnormal;
		varying vec4 pcolor;

	#else
	
		varying mat3	TBN;
		
	#endif
		
#endif				

varying vec4 		curpos;/*,
					prev;*/
uniform float		vScale;
uniform float 		fade;

varying vec2 depth;

vec2 encode(vec3 n)
{
	n=normalize(n);
    float f = sqrt(8.0*n.z+8.0);
    return n.xy / f + 0.5;
}

// NOISE ----------------------------------------------------
float bayer2(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  (bayer16(.5*(a))*.25+bayer2(a))
#define bayer64(a)  (bayer32(.5*(a))*.25+bayer2(a))
#define bayer128(a) (bayer64(.5*(a))*.25+bayer2(a))
// -----------------------------------------------------------

void main()
{
	//vec2 screenCoords=curpos.xy*0.5+0.5;

	#ifdef PSYSTEM
	
	if(life<=0.0)
		discard;
			
	#endif

	float 	fdalpha;
	vec3	fnormal;
	vec2	fspec,
			ffresnel;
	float 	metal=metal0;
	
	vec4 color=/*pow(*/texture2D(dif0,texcoord.st*dscale0+dofs0);//.rgb,vec3(2.2))
	color.rgb=	pow(color.rgb,vec3(2.2));
			
	#ifdef ALPHATEST

		fdalpha=color.a;//texture2D(dif0,texcoord.st*dscale0+dofs0).a;
	
		#ifdef PSYSTEM
			float alpha=fdalpha*life;
			if(alpha<=alphalevel)
				discard;
		#else
			#ifdef BSET
				float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,screenCoords.st*10.0).r;
				if(alpha>pcolor.w)
					discard;
			#else
				#ifdef MSET
					float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,screenCoords.st*10.0).r;
					if(alpha>fade)
						discard;
				#else
					#ifdef _HEIGHTMAP_
					#else
						#ifdef SKINNING
						#else
							#ifndef _NOT_INSTANCED_
								float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,screenCoords.st*10.0).r;
								if(alpha>alphaFade)
									discard;
							#else
								float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,screenCoords.st*10.0).r;
								if(alpha>fade)
									discard;
							#endif
						#endif
					#endif
				#endif
			#endif
			
			#ifdef BSET
				if(fdalpha<=alphalevel)
					discard;
			#else
				if(fdalpha<=mix(alphalevel,alphalevel*0.8,clamp(curpos.z*25000.0-4500.0,0.0,1.0)))
					discard;
			#endif
		#endif
		
	#endif
			
	#ifdef BSET
	
	#else
		fnormal.xyz=vec3(0.0,0.0,1.0);
		//ffresnel.y=fresnel0.y*0.5;
	#endif

	float isNotMetal=step(metal,0.0); // if metal > 0 then isNotMetal = 0 else isNotMetal=1
	//vec3 color=pow(texture2D(dif0,texcoord*dscale0+dofs0).rgb,vec3(2.2))*vertColor;//*dcolor0.rgb
	gl_FragData[0]=vec4(color.rgb*vertColor,scatterlevel*isNotMetal/*1.0*/);//fdcolor;

	#ifdef PSYSTEM
			
		gl_FragData[1].xy=encode(vec3((fnormal.x*cosa)+(fnormal.y*sina),(fnormal.x*sina)-(fnormal.y*cosa),fnormal.z));
			
	#else
		
		#ifdef BSET
			
			vec3 one=vec3(1.0,1.0,1.0);
			vec3 rmul=gl_FragData[0].rgb*pcolor.xyz;
			vec3 rscr=one-((one-pcolor.xyz)*(one-gl_FragData[0].rgb));
			gl_FragData[0].rgb=gl_FragData[0].rgb*rscr+(one-gl_FragData[0].rgb)*rmul;
			gl_FragData[1].xy = encode(pnormal.xyz);
			
		#else
		
			// normal
			gl_FragData[1].xy=encode(TBN*fnormal.xyz);
			
		#endif
			
	#endif
	
	gl_FragData[1].z=0.0;//reflMul*0.0625;///16.0;
	gl_FragData[1].a=backScatter;
	
	// pos
	//vec2 vel=((curpos.xy/curpos.w)-(prev.xy/prev.w))*vScale;
	
	// material params
	//float M=mix(metal,matID,isNotMetal); // matID if isNotMetal=1 else metal
	gl_FragData[2].r=matID;//M;//scatterlevel; 
	gl_FragData[2].g=1.0;//ffresnel.y*0.00390625; 
	//gl_FragData[2].ba=(vel*vec2(0.5))+vec2(0.5);
}
